<?php
defined("ABSPATH") || exit();

class SuperbInfoContentConfig
{
    const THEME_LINK = 'https://superbthemes.com/blogrid/';
    const DEMO_LINK = 'https://superbthemes.com/demo/blogrid/';

    private $FEATURES = array();

    public function __construct()
    {
        $this->AddFeature(__("Customize Header Logo, Text & Background Color", "blogrid"), "purple-paint-brush.svg");
        $this->AddFeature(__("Translation Ready", "blogrid"), "purple-article-medium.svg");
        $this->AddFeature(__("Fully SEO Optimized", "blogrid"), "purple-gauge.svg");
        $this->AddFeature(__("Customize All Fonts", "blogrid"), "purple-article-medium.svg");
        $this->AddFeature(__("Customize All Colors", "blogrid"), "purple-paint-brush.svg");
        $this->AddFeature(__("Importable Demo Content", "blogrid"), "purple-images.svg");
        $this->AddFeature(__("Elementor Compatible", "blogrid"), "purple-elementor-logo.svg");
        $this->AddFeature(__("Replace Copyright Text", "blogrid"), "purple-copyright.svg");
        $this->AddFeature(__("Full-Width Page Template", "blogrid"), "purple-frame-corners.svg");
        $this->AddFeature(__("Access All Child Themes", "blogrid"), "purple-images.svg");
        $this->AddFeature(__("Customer Support and Documentation", "blogrid"), "purple-files.svg");
        $this->AddFeature(__("Multiple Website Support", "blogrid"), "purple-files.svg");

        $this->AddFeature(__("Only Show Header Image On Front Page", "blogrid"), "gear.svg");
        $this->AddFeature(__("Show Header Everywhere", "blogrid"), "gear.svg");
        $this->AddFeature(__("Custom Text On Header Image", "blogrid"), "gear.svg");
        $this->AddFeature(__("Full Width Page & Post Template", "blogrid"), "gear.svg");
        $this->AddFeature(__("Only Show Upper Widgets On Front Page", "blogrid"), "gear.svg");
        $this->AddFeature(__("Hide Sidebar (Full-width mode)", "blogrid"), "gear.svg");

        $this->AddFeature(__("Remove 'Tag' from Tag Page Title", "blogrid"), "purple-article-medium.svg");
        $this->AddFeature(__("Remove 'Author' from Author Page Title", "blogrid"), "purple-article-medium.svg");
        $this->AddFeature(__("Remove 'Category' from Category Page Title", "blogrid"), "purple-article-medium.svg");
    }

    private function AddFeature($title, $icon)
    {
        $this->FEATURES[] = array(
            "title" => $title,
            "icon" => $icon
        );
    }

    public function GetFeatures()
    {
        return $this->FEATURES;
    }
}
